/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.tenant.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.tenant.model.vo.ApiTenantVO;
import com.elitescloud.cloudt.tenant.model.vo.params.ApiTenantQueryParamVO;
import com.elitescloud.cloudt.tenant.service.ApiTenantService;
import com.elitescloud.cloudt.tenant.service.repo.SysTenantRepoProc;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class ApiTenantServiceImpl
implements ApiTenantService {
    @Autowired
    private SysTenantRepoProc tenantRepoProc;

    @Override
    public ApiResult<List<ApiTenantVO>> queryAll() {
        List<ApiTenantVO> tenants = this.tenantRepoProc.allApi();
        return ApiResult.ok(tenants);
    }

    @Override
    public ApiResult<PagingVO<ApiTenantVO>> query(ApiTenantQueryParamVO queryParamVO) {
        PagingVO<ApiTenantVO> tenants = this.tenantRepoProc.queryApi(queryParamVO);
        return ApiResult.ok(tenants);
    }

    @Override
    public ApiResult<Boolean> execSetCurrentTenant(Long id) {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user == null) {
            throw new BusinessException(ApiCode.UNAUTHORIZED, "\u8bf7\u5148\u767b\u5f55");
        }
        SysTenantDTO tenant = null;
        if (CollUtil.isNotEmpty((Collection)user.getUser().getSysTenantDTOList())) {
            for (SysTenantDTO tenantDTO : user.getUser().getSysTenantDTOList()) {
                if (!tenantDTO.getId().equals(id)) continue;
                tenant = tenantDTO;
                break;
            }
        }
        if (tenant == null) {
            return ApiResult.fail((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u79df\u6237");
        }
        user.getUser().setSysTenantVO(tenant);
        SecurityContextUtil.updateCurrentUser((GeneralUserDetails)user);
        return ApiResult.ok((Object)true);
    }
}

