/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.tenant.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.service.repo.SysTenantAppRepoProc;
import com.elitescloud.cloudt.tenant.convert.SysTenantDatasourceConvert;
import com.elitescloud.cloudt.tenant.model.entity.SysTenantDatasourceDO;
import com.elitescloud.cloudt.tenant.model.vo.params.SysTenantDatasourceRespVO;
import com.elitescloud.cloudt.tenant.model.vo.params.SysTenantDatasourceSaveVO;
import com.elitescloud.cloudt.tenant.service.SysTenantDatasourceService;
import com.elitescloud.cloudt.tenant.service.repo.SysTenantDatasourceRepoProc;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class SysTenantDatasourceServiceImpl
extends BaseServiceImpl
implements SysTenantDatasourceService {
    private static final CodeNameParam APP_DEFAULT = new CodeNameParam("default", "\u9ed8\u8ba4");
    private static final String DRIVER_DEF = "net.sf.log4jdbc.sql.jdbcapi.DriverSpy";
    @Autowired
    private SysTenantDatasourceRepoProc repoProc;
    @Autowired
    private SysTenantAppRepoProc tenantAppRepoProc;

    @Override
    public ApiResult<List<CodeNameParam>> appList(Long sysTenantId) {
        if ((sysTenantId = this.normalizeTenantId(sysTenantId)) == null) {
            return ApiResult.fail((String)"\u79df\u6237ID\u4e3a\u7a7a");
        }
        List tenantAppList = this.tenantAppRepoProc.getAppOfTenant(sysTenantId.longValue());
        ArrayList<CodeNameParam> appList = new ArrayList<CodeNameParam>(16);
        appList.add(APP_DEFAULT);
        appList.addAll(tenantAppList);
        return ApiResult.ok(appList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(SysTenantDatasourceSaveVO saveVO) {
        SysTenantDatasourceDO datasourceDO = this.saveVo2Do(saveVO);
        this.repoProc.save((Serializable)((Object)datasourceDO));
        return ApiResult.ok((Object)datasourceDO.getId());
    }

    @Override
    public ApiResult<String> testConnection(SysTenantDatasourceSaveVO saveVO) {
        saveVO.setSysTenantId(this.normalizeTenantId(saveVO.getSysTenantId()));
        Assert.notNull((Object)saveVO.getSysTenantId(), (String)"\u79df\u6237ID\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)saveVO.getAppCode(), (String)"\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        String failMsg = null;
        if (Boolean.TRUE.equals(saveVO.getUseDef())) {
            SysTenantDatasourceDO defaultDatasource = this.repoProc.getByTenantAndApp(saveVO.getSysTenantId(), saveVO.getAppCode());
            if (defaultDatasource == null) {
                return ApiResult.fail((String)"\u8bf7\u5148\u914d\u7f6e\u9ed8\u8ba4\u6570\u636e\u6e90");
            }
            failMsg = this.connectionDatasource(defaultDatasource.getDsUrl(), defaultDatasource.getDsUsername(), defaultDatasource.getDsPassword(), defaultDatasource.getDsDriver(), defaultDatasource.getDsPoolProp());
        } else {
            failMsg = this.connectionDatasource(saveVO.getDsUrl(), saveVO.getDsUsername(), saveVO.getDsPassword(), saveVO.getDsDriver(), saveVO.getDsPoolProp());
        }
        if (CharSequenceUtil.isBlank((CharSequence)failMsg)) {
            return ApiResult.ok((Object)"\u6570\u636e\u6e90\u6709\u6548\uff0c\u53ef\u4f7f\u7528");
        }
        return ApiResult.fail((String)("\u6570\u636e\u6e90\u65e0\u6548\uff0c\u8fde\u63a5\u5931\u8d25\uff1a" + failMsg));
    }

    @Override
    public ApiResult<SysTenantDatasourceRespVO> get(Long sysTenantId, String appCode) {
        if ((sysTenantId = this.normalizeTenantId(sysTenantId)) == null) {
            return ApiResult.fail((String)"\u79df\u6237ID\u4e3a\u7a7a");
        }
        if (CharSequenceUtil.isBlank((CharSequence)appCode)) {
            return ApiResult.fail((String)"\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a");
        }
        SysTenantDatasourceDO datasourceDO = this.repoProc.getByTenantAndApp(sysTenantId, appCode);
        if (datasourceDO == null) {
            return ApiResult.ok();
        }
        SysTenantDatasourceRespVO respVO = SysTenantDatasourceConvert.INSTANCE.do2RespVO(datasourceDO);
        return ApiResult.ok((Object)respVO);
    }

    private String connectionDatasource(String url, String username, String password, String driver, String prop) {
        return null;
    }

    private SysTenantDatasourceDO saveVo2Do(SysTenantDatasourceSaveVO saveVO) {
        SysTenantDatasourceDO datasourceDO;
        saveVO.setSysTenantId(this.normalizeTenantId(saveVO.getSysTenantId()));
        Assert.notNull((Object)saveVO.getSysTenantId(), (String)"\u79df\u6237ID\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)saveVO.getAppCode(), (String)"\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        saveVO.setEnabled((Boolean)ObjectUtil.defaultIfNull((Object)saveVO.getEnabled(), (Object)false));
        saveVO.setUseDef((Boolean)ObjectUtil.defaultIfNull((Object)saveVO.getUseDef(), (Object)false));
        if (Boolean.FALSE.equals(saveVO.getUseDef())) {
            this.validateDatasourceConfig(saveVO);
        }
        if ((datasourceDO = this.repoProc.getByTenantAndApp(saveVO.getSysTenantId(), saveVO.getAppCode())) == null) {
            datasourceDO = SysTenantDatasourceConvert.INSTANCE.saveVo2Do(saveVO);
        } else {
            SysTenantDatasourceConvert.INSTANCE.copySaveVo2Do(saveVO, datasourceDO);
        }
        datasourceDO.setDef(APP_DEFAULT.getCode().equals(saveVO.getAppCode()));
        return datasourceDO;
    }

    private void validateDatasourceConfig(SysTenantDatasourceSaveVO saveVO) {
        Assert.notBlank((CharSequence)saveVO.getDsUrl(), (String)"\u6570\u636e\u6e90url\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)saveVO.getDsUsername(), (String)"\u6570\u636e\u6e90\u8d26\u53f7\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)saveVO.getDsPassword(), (String)"\u6570\u636e\u6e90\u5bc6\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        saveVO.setDsDriver(CharSequenceUtil.blankToDefault((CharSequence)saveVO.getDsDriver(), (String)DRIVER_DEF));
    }

    private Long normalizeTenantId(Long sysTenantId) {
        if (sysTenantId != null && sysTenantId.longValue() != TenantConstant.DEFAULT_TENANT_ID.longValue()) {
            return sysTenantId;
        }
        SysTenantDTO tenant = super.currentTenant();
        if (tenant == null) {
            return null;
        }
        return tenant.getId();
    }
}

