/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.tenant.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.service.callback.UserChangedCallback;
import com.elitescloud.cloudt.system.service.model.bo.SysUserSaveBO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantUserDO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.elitescloud.cloudt.system.service.repo.SysTenantUserRepo;
import com.elitescloud.cloudt.system.service.repo.SysTenantUserRepoProc;
import java.time.LocalDateTime;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class UserChangedCallbackTenantServiceImpl
implements UserChangedCallback {
    private static final Logger log = LogManager.getLogger(UserChangedCallbackTenantServiceImpl.class);
    @Autowired
    private TenantClientProvider tenantClientProvider;
    @Autowired
    private SysTenantUserRepo tenantUserRepo;
    @Autowired
    private SysTenantUserRepoProc tenantUserRepoProc;

    @Transactional(rollbackFor={Exception.class})
    public void onUpsert(boolean add, SysUserSaveBO saveBO, SysUserDO userDO) {
        if (!this.tenantClientProvider.enabledTenant()) {
            log.info("\u672a\u542f\u7528\u79df\u6237\u529f\u80fd");
            return;
        }
        if (add) {
            this.onInsert(saveBO, userDO);
            return;
        }
        this.onUpdate(saveBO, userDO);
    }

    @Transactional(rollbackFor={Exception.class})
    public void onEnabled(Long userId, boolean enabled) {
        if (!this.tenantClientProvider.enabledTenant()) {
            log.info("\u672a\u542f\u7528\u79df\u6237\u529f\u80fd");
            return;
        }
        Long tenantId = this.currentTenantId();
        this.tenantUserRepoProc.updateEnabled(tenantId, userId, Boolean.valueOf(enabled));
    }

    @Transactional(rollbackFor={Exception.class})
    public void onUpdatePassword(Long userId, String password, String originalPassword) {
    }

    @Transactional(rollbackFor={Exception.class})
    public void onUpdateMobile(Long userId, String mobile) {
    }

    @Transactional(rollbackFor={Exception.class})
    public void onUpdateEmail(Long userId, String email) {
    }

    @Transactional(rollbackFor={Exception.class})
    public void onDelete(Long userId, Long casUserId) {
        if (!this.tenantClientProvider.enabledTenant()) {
            log.info("\u672a\u542f\u7528\u79df\u6237\u529f\u80fd");
            return;
        }
        Long tenantId = this.currentTenantId();
        this.tenantUserRepoProc.unbindTenant(tenantId.longValue(), userId.longValue());
    }

    private void onInsert(SysUserSaveBO saveBO, SysUserDO userDO) {
        Long tenantId = this.currentTenantId();
        log.info("\u7ed1\u5b9a\u7528\u6237{}\u4e0e\u79df\u6237{}", (Object)userDO.getId(), (Object)tenantId);
        SysTenantUserDO tenantUserDO = new SysTenantUserDO();
        tenantUserDO.setSysUserId(userDO.getId());
        tenantUserDO.setSysTenantId(tenantId);
        tenantUserDO.setBindTime(LocalDateTime.now());
        tenantUserDO.setExpiredTime(saveBO.getExpiredTime());
        tenantUserDO.setEnabled((Boolean)ObjectUtil.defaultIfNull((Object)saveBO.getEnabled(), (Object)true));
        tenantUserDO.setDef(Boolean.valueOf(false));
        this.tenantUserRepo.save((Object)tenantUserDO);
    }

    private void onUpdate(SysUserSaveBO saveBO, SysUserDO userDO) {
        Long tenantId = this.currentTenantId();
        SysTenantUserDO tenantUserDO = this.tenantUserRepoProc.get(tenantId, userDO.getId());
        if (tenantUserDO == null) {
            this.onInsert(saveBO, userDO);
            return;
        }
        tenantUserDO.setExpiredTime(saveBO.getExpiredTime());
        tenantUserDO.setEnabled(saveBO.getEnabled());
        this.tenantUserRepo.save((Object)tenantUserDO);
    }

    private Long currentTenantId() {
        SysTenantDTO currentTenant = TenantClient.getCurrentTenant();
        return currentTenant == null ? TenantConstant.DEFAULT_TENANT_ID : currentTenant.getId();
    }
}

