package com.elitescloud.cloudt.tenant.config;

import com.elitescloud.boot.condition.ConditionalOnRpc;
import com.elitescloud.boot.condition.ConditionalOnTenant;
import com.elitescloud.boot.tenant.client.support.TenantProviderService;
import com.elitescloud.cloudt.system.service.config.TenantProperties;
import com.elitescloud.cloudt.tenant.config.support.SystemTenantProviderService;
import com.elitescloud.cloudt.tenant.controller.*;
import com.elitescloud.cloudt.tenant.controller.api.ApiTenantController;
import com.elitescloud.cloudt.tenant.rpc.TenantRpcProviderImpl;
import com.elitescloud.cloudt.tenant.service.*;
import com.elitescloud.cloudt.tenant.service.impl.*;
import com.elitescloud.cloudt.tenant.service.manager.SysTenantManager;
import com.elitescloud.cloudt.tenant.service.manager.TenantClientCaller;
import com.elitescloud.cloudt.tenant.service.manager.impl.DubboTenantClientCaller;
import com.elitescloud.cloudt.tenant.service.manager.impl.OpenFeignTenantClientCaller;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

/**
 * 租户配置.
 *
 * @author Kaiser（wang shao）
 * 2022/3/25
 */
@Configuration(proxyBeanMethods = false)
@ConditionalOnTenant
@EnableConfigurationProperties(TenantProperties.class)
@Import({TenantConfig.SupportedService.class})
public class TenantConfig implements ApplicationRunner {

    private SysTenantBaseDataSyncService tenantBaseDataSyncService;

    @Bean
    @ConditionalOnRpc(requiredDubbo = true)
    public TenantClientCaller dubboTenantClientCaller() {
        return new DubboTenantClientCaller();
    }

    @Bean
    @ConditionalOnMissingBean(TenantClientCaller.class)
    @ConditionalOnRpc(requiredOpenFeign = true)
    public TenantClientCaller openFeignTenantClientCaller(ApplicationContext applicationContext
            , DiscoveryClient discoveryClient) {
        return new OpenFeignTenantClientCaller(applicationContext, discoveryClient);
    }

    @Bean
    @Primary
    public TenantProviderService serverTenantProvider(SysTenantQueryService tenantService) {
        return new SystemTenantProviderService(tenantService);
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        if (tenantBaseDataSyncService != null) {
            tenantBaseDataSyncService.execDealUnFinished();
        }
    }

    @Autowired(required = false)
    public void setTenantBaseDataSyncService(SysTenantBaseDataSyncService tenantBaseDataSyncService) {
        this.tenantBaseDataSyncService = tenantBaseDataSyncService;
    }

    /**
     * 手动注册的服务
     */
    static class SupportedService {
        @Bean
        public ApiTenantController apiTenantController() {
            return new ApiTenantController();
        }

        @Bean
        public SysTenantAppController sysTenantAppController() {
            return new SysTenantAppController();
        }

        @Bean
        public SysTenantBaseDataSyncController sysTenantBaseDataSyncController(SysTenantBaseDataSyncService sysTenantBaseDataSyncService) {
            return new SysTenantBaseDataSyncController(sysTenantBaseDataSyncService);
        }

        @Bean
        public SysTenantManager sysTenantManager() {
            return new SysTenantManager();
        }

        @Bean
        public SysTenantBaseDataSyncService sysTenantBaseDataSyncService() {
            return new SysTenantBaseDataSyncServiceImpl();
        }

        @Bean
        public SysTenantController sysTenantController() {
            return new SysTenantController();
        }

        @Bean
        public SysTenantDbMigrateController sysTenantDbMigrateController() {
            return new SysTenantDbMigrateController();
        }

        @Bean
        public SysTenantUserController sysTenantUserController() {
            return new SysTenantUserController();
        }

        @Bean
        public TenantRpcProviderImpl tenantRpcProvider() {
            return new TenantRpcProviderImpl();
        }

        @Bean
        public ApiTenantService apiTenantService() {
            return new ApiTenantServiceImpl();
        }

        @Bean
        public SysTenantDbMigrateService sysTenantDbMigrateService() {
            return new SysTenantDbMigrateServiceImpl();
        }

        @Bean
        public SysTenantMngService sysTenantService() {
            return new SysTenantMngServiceImpl();
        }

        @Bean
        public SysTenantQueryService sysTenantQueryService() {
            return new SysTenantQueryServiceImpl();
        }

        @Bean
        public SysTenantDatasourceService sysTenantDatasourceService() {
            return new SysTenantDatasourceServiceImpl();
        }

        @Bean
        public SysTenantDatasourceController sysTenantDatasourceController() {
            return new SysTenantDatasourceController();
        }
    }
}
