/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.tenant.service.manager.impl;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.elitescloud.boot.dubbo.util.DubboNacosHolder;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.tenant.client.common.TenantDatabaseRpcProvider;
import com.elitescloud.cloudt.tenant.service.manager.TenantClientCaller;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.lang.NonNull;

public class DubboTenantClientCaller
implements TenantClientCaller {
    private static final Logger log = LogManager.getLogger(DubboTenantClientCaller.class);

    @Override
    public Set<String> allAppCodes() {
        Class<TenantDatabaseRpcProvider> clientInterface = TenantDatabaseRpcProvider.class;
        return this.queryClientInstance(clientInterface).keySet();
    }

    @Override
    public boolean callDatabaseRpcProvider(@NonNull String appCode, Integer timeout, @NonNull Predicate<TenantDatabaseRpcProvider> rpcProviderFunction) {
        Class<TenantDatabaseRpcProvider> clientInterface = TenantDatabaseRpcProvider.class;
        Map<String, List<Instance>> clientInstanceMap = this.queryClientInstance(clientInterface);
        List<Instance> instances = clientInstanceMap.get(appCode);
        if (instances.isEmpty()) {
            throw new BusinessException("\u8c03\u7528\u79df\u6237\u5ba2\u6237\u7aef\u65f6\u672a\u67e5\u8be2\u5230\u6709\u6548\u5ba2\u6237\u7aef");
        }
        TenantDatabaseRpcProvider provider = null;
        String lastError = null;
        for (Instance instance : instances) {
            boolean result;
            try {
                provider = (TenantDatabaseRpcProvider)DubboNacosHolder.getInstanceOfSpecial(clientInterface, null, (Instance)instance, (Integer)timeout);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u79df\u6237\u5ba2\u6237\u7aef\u5f02\u5e38\uff1a", (Throwable)e);
                lastError = "\u83b7\u53d6\u79df\u6237\u5ba2\u6237\u7aef\u5931\u8d25\uff1a" + e.getMessage();
                continue;
            }
            try {
                result = rpcProviderFunction.test(provider);
            }
            catch (Exception e) {
                lastError = "\u79df\u6237\u5ba2\u6237\u7aef\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage();
                continue;
            }
            if (!result) continue;
            log.info("\u8c03\u7528\u79df\u6237\u5ba2\u6237\u7aef\u63a5\u53e3\u6210\u529f\uff1a{}", (Object)appCode);
            return true;
        }
        throw new BusinessException(lastError);
    }

    private Map<String, List<Instance>> queryClientInstance(Class<?> clientInterface) {
        String serviceName = DubboNacosHolder.buildServiceName((String)"providers", clientInterface, null);
        Map instanceMap = null;
        try {
            instanceMap = DubboNacosHolder.queryNacosInstanceForApplication((String)serviceName, null);
        }
        catch (NacosException e) {
            throw new BusinessException("\u67e5\u8be2\u79df\u6237\u7684\u4e1a\u52a1\u5ba2\u6237\u7aef\u5931\u8d25", (Throwable)e);
        }
        if (instanceMap.isEmpty()) {
            return instanceMap;
        }
        HashMap<String, List<Instance>> resultMap = new HashMap<String, List<Instance>>(instanceMap.size());
        List instances = null;
        for (Map.Entry entry : instanceMap.entrySet()) {
            instances = ((List)entry.getValue()).stream().filter(t -> t.isEnabled() && t.isHealthy()).collect(Collectors.toList());
            if (instances.isEmpty()) continue;
            resultMap.put((String)entry.getKey(), instances);
        }
        return resultMap;
    }
}

