package com.elitescloud.cloudt.tenant.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 租户数据源.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/25
 */
@Entity
@Table(name = "sys_tenant_datasource", indexes = {
        @Index(name = "idx_tenant_ds_tenantid", columnList = "sysTenantId"),
        @Index(name = "idx_tenant_ds_tenantapp", columnList = "sysTenantId,appCode", unique = true),
})
@Comment("租户数据源")
@DynamicUpdate
@DynamicInsert
@Getter
@Setter
@Accessors(chain = true)
public class SysTenantDatasourceDO extends BaseModel {
    private static final long serialVersionUID = 2705402679546962920L;

    @Comment(value = "租户ID")
    @Column(nullable = false)
    private Long sysTenantId;

    @Comment(value = "应用编码")
    @Column()
    private String appCode;

    @Comment(value = "是否是默认数据源")
    @Column()
    private Boolean def;

    @Comment(value = "是否使用默认数据源")
    @Column()
    private Boolean useDef;

    @Comment(value = "连接地址")
    @Column()
    private String dsUrl;

    @Comment(value = "账号")
    @Column()
    private String dsUsername;

    @Comment(value = "密码")
    @Column()
    private String dsPassword;

    @Comment(value = "驱动类")
    @Column()
    private String dsDriver;

    @Comment(value = "连接池配置")
    @Column()
    @Lob
    private String dsPoolProp;

    @Comment(value = "是否启用")
    @Column()
    private Boolean enabled;
}
