package com.elitescloud.cloudt.tenant.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.tenant.service.SysTenantBaseDataSyncService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 基础数据同步.
 *
 * @author Kaiser（wang shao）
 * 2022/10/12
 */
@ResponseBody
@RequestMapping(value = "/sys/tenantBaseData", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "基础数据同步", tags = {"基础数据同步"})
@Validated
public class SysTenantBaseDataSyncController {

    private final SysTenantBaseDataSyncService baseDataSyncService;

    public SysTenantBaseDataSyncController(SysTenantBaseDataSyncService baseDataSyncService) {
        this.baseDataSyncService = baseDataSyncService;
    }

    /**
     * 同步基础数据
     *
     * @param tenantId 租户ID
     * @return 同步结果
     */
    @PostMapping(value = "/sync/{tenantId}")
    @ApiOperation(value = "同步基础数据")
    @ApiImplicitParam(name = "tenantId", value = "租户ID", required = true, dataType = "int")
    public ApiResult<Boolean> syncData(@PathVariable("tenantId") Long tenantId) {
        return baseDataSyncService.execSyncData(tenantId);
    }
}
