package com.elitescloud.cloudt.tenant.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.tenant.model.vo.ApiTenantVO;
import com.elitescloud.cloudt.tenant.model.vo.params.ApiTenantQueryParamVO;
import com.elitescloud.cloudt.tenant.service.ApiTenantService;
import com.elitescloud.cloudt.tenant.service.repo.SysTenantRepoProc;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/4/24
 */
@TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg = false)
public class ApiTenantServiceImpl implements ApiTenantService {

    @Autowired
    private SysTenantRepoProc tenantRepoProc;

    @Override
    public ApiResult<List<ApiTenantVO>> queryAll() {
        var tenants = tenantRepoProc.allApi();
        return ApiResult.ok(tenants);
    }

    @Override
    public ApiResult<PagingVO<ApiTenantVO>> query(ApiTenantQueryParamVO queryParamVO) {
        var tenants = tenantRepoProc.queryApi(queryParamVO);
        return ApiResult.ok(tenants);
    }

    @Override
    public ApiResult<Boolean> execSetCurrentTenant(Long id) {
        var user = SecurityContextUtil.currentUser();
        if (user == null) {
            throw new BusinessException(ApiCode.UNAUTHORIZED, "请先登录");
        }

        // 解析对应的租户
        SysTenantDTO tenant = null;
        if (CollUtil.isNotEmpty(user.getUser().getSysTenantDTOList())) {
            for (SysTenantDTO tenantDTO : user.getUser().getSysTenantDTOList()) {
                if (tenantDTO.getId().equals(id)) {
                    tenant = tenantDTO;
                    break;
                }
            }
        }
        if (tenant == null) {
            return ApiResult.fail("未找到对应的租户");
        }
        user.getUser().setSysTenantVO(tenant);

        // 更新当前用户信息
        SecurityContextUtil.updateCurrentUser(user);

        return ApiResult.ok(true);
    }
}
