package com.elitescloud.cloudt.workflow.params.req;

import com.elitescloud.cloudt.workflow.params.FileInfoDTO;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * 中断流程实例
 *
 * @author yangzhibin
 * @date 2020/9/29
 */
@Getter
@Setter
public class ProcInvalidDTO implements Serializable {
    private static final long serialVersionUID = 3411177922577646189L;

    /**
     * 流程实例ID
     */
    @NotBlank
    private String processInstanceId;

    /**
     * 意见
     */
    private String comment;

    /**
     * 附件信息
     */
    private List<FileInfoDTO> fileInfoList;
}
