package com.elitesland.workflow;

import lombok.Data;

/**
 * @author yangzhibin
 * @date 2023/1/9
 */
@Data
public class WorkflowResult<T> {

    /**
     * 是否成功
     */
    private boolean success;

    /**
     * 错误消息
     */
    private String msg;

    /**
     * 数据
     */
    private T data;

    public WorkflowResult() {
    }

    public WorkflowResult(boolean success, String msg, T data) {
        this.success = success;
        this.msg = msg;
        this.data = data;
    }

    public static <T> WorkflowResult<T> success(T data) {
        return new WorkflowResult(true, null, data);
    }
}
