package com.elitescloud.cloudt.workflow.config;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.workflow.config.common.FeignHeaderCustomizer;
import feign.RequestInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.List;

/**
 * @author yangzhibin
 * @date 2022/11/24
 */
public class FeignSupportConfig {

    @Bean
    public RequestInterceptor requestInterceptor(List<FeignHeaderCustomizer> headerCustomizers) {
        return requestTemplate -> {
            //请求头转发
            ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
            if (attributes != null) {
                HttpServletRequest request = attributes.getRequest();
                Enumeration<String> headerNames = request.getHeaderNames();
                if (headerNames != null) {
                    while (headerNames.hasMoreElements()) {
                        String headerName = headerNames.nextElement();
                        String header = request.getHeader(headerName);
                        if (headerName.equalsIgnoreCase("Content-Length")) {
                            continue;
                        }
                        if (headerName.equalsIgnoreCase("Content-Type")) {
                            continue;
                        }
                        if (headerName.equalsIgnoreCase("Accept")) {
                            continue;
                        }
                        if (headerName.equalsIgnoreCase("Accept-Encoding")) {
                            continue;
                        }
                        if (headerName.equalsIgnoreCase("Cookie")) {
                            continue;
                        }
                        if (headerName.equalsIgnoreCase("Host")) {
                            continue;
                        }
                        if (headerName.equalsIgnoreCase("Connection")) {
                            continue;
                        }
                        if (headerName.equalsIgnoreCase("Referer")) {
                            continue;
                        }
                        if (headerName.equalsIgnoreCase("User-Agent")) {
                            continue;
                        }
                        requestTemplate.header(headerName, header);
                    }
                }
            }

            // 自定义请求头处理
            if (CollUtil.isNotEmpty(headerCustomizers)) {
                for (FeignHeaderCustomizer headerCustomizer : headerCustomizers) {
                    headerCustomizer.customize(requestTemplate);
                }
            }
        };
    }
}
