package com.elitesland.workflow;

import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;

import java.util.ArrayList;

/**
 * <p>
 * 工作流回调
 * <p>
 * 这个业务方提供给工作流使用的
 * <p>
 * 使用方法:
 * 1,定义一个类实现该接口
 * 2,在类上使用@DubboService
 * 3,实现接口方法
 *
 * </p >
 *
 * @author yangzhibin
 * @date 2020/8/19
 */
public interface WorkflowCallBack {

    /**
     * 动态指定任务负责人的回调
     * <p>
     * 获取该任务的负责人
     *
     * @param payload 负载参数
     * @return 负责人ID
     */
    WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload);

    /**
     * 任务创建的回调
     *
     * @param payload 负载参数
     */
    WorkflowResult<Void> taskCreated(TaskCreatedPayload payload);

    /**
     * 任务完成回调
     * <p>
     * 只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调
     *
     * @param payload 负载参数
     */
    WorkflowResult<Void> taskCompleted(TaskCompletedPayload payload);

    /**
     * 流程状态变化的回调
     *
     * @param payload 负载参数
     */
    WorkflowResult<Void> processStatusChange(ProcessStatusChangePayload payload);

}
