package com.elitesland.workflow.payload;

import com.elitescloud.cloudt.workflow.params.FileInfoDTO;
import lombok.Data;

import java.util.List;

/**
 * @author yangzhibin
 * @date 2022/11/27
 */
@Data
public class DeleteProcessPayload {
    private String procInstId;
    private String comment;

    /**
     * 附件信息
     */
    private List<FileInfoDTO> fileInfoList;

    public static DeleteProcessPayload of(String procInstId, String comment) {
        DeleteProcessPayload payload = new DeleteProcessPayload();
        payload.setProcInstId(procInstId);
        payload.setComment(comment);
        return payload;
    }
}
