package com.elitescloud.cloudt.workflow.params;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 流程定义信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/12
 */
@Getter
@Setter
public class ProcDefDTO implements Serializable {
    private static final long serialVersionUID = -2568463111203732336L;

    /**
     * ID
     */
    private Long id;

    /**
     * 流程名称
     */
    private String name;
    /**
     * 流程key
     */
    private String key;

    /**
     * 类别ID
     */
    private Long categoryId;

    /**
     * 类别名称
     */
    private String categoryName;

    /**
     * 微服务访问前缀(格式 http://${application.name}/${context_path})
     */
    private String appPrefixUrl;

    /**
     * 是否支持作废动作
     */
    private Boolean supportInvalid;

    /**
     * 扩展参数
     */
    private String es1;
    private String es2;
    private String es3;
    private String es4;
    private String es5;

    /**
     * 流程定义的状态
     */
    private String state;
    private String stateName;

    /**
     * 是否使用流程表单
     */
    private Boolean form;

    /**
     * 功能模块编码
     */
    private String moduleCode;

    /**
     * 功能模块名称
     */
    private String moduleName;
}
