package com.elitescloud.cloudt.workflow.params.save;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 流程定义保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/19
 */
@Getter
@Setter
public class ProcDefSaveDTO implements Serializable {
    private static final long serialVersionUID = 3941549972922735354L;

    /**
     * 修改时不能为空
     */
    private Long id;

    /**
     * 流程类别ID
     */
    @NotNull(message = "流程定义ID为空")
    private Long categoryId;

    /**
     * 流程名称
     */
    @NotBlank(message = "流程名称为空")
    private String name;

    /**
     * 流程key
     */
    @NotBlank(message = "流程Key为空")
    private String key;

    /**
     * 微服务访问前缀
     * <p>
     * (格式 http://${application.name}/${context_path})
     */
    private String appPrefixUrl;

    /**
     * 是否使用流程表单
     */
    private Boolean form;

    /**
     * 功能模块编码
     */
    private String moduleCode;

    /**
     * 功能模块名称
     */
    private String moduleName;
}
