package com.elitescloud.cloudt.workflow.service.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.workflow.Application;
import com.elitescloud.cloudt.workflow.params.req.ProcInterruptDTO;
import com.elitescloud.cloudt.workflow.params.req.ProcInvalidDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;

/**
 * 流程实例服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2025/6/3 周二
 */
@FeignClient(name = Application.NAME, path = ProcInstRpcService.URI)
public interface ProcInstRpcService {
    String URI = Application.URI_PREFIX + "/procInst";

    @PostMapping(value = "/updateProcInstName")
    ApiResult<String> updateProcInstName(@NotBlank(message = "流程实例ID为空") @RequestParam(name = "procInstId") String procInstId,
                                         @NotBlank(message = "流程实例名称为空") @RequestParam(name = "procInstName") String procInstName);

    /**
     * 作废流程
     * <p>
     * 流程直接结束，到最后一个节点
     *
     * @param invalidDTO
     * @return
     */
    @PostMapping(value = "/invalidProcInst")
    ApiResult<String> invalidProcInst(@RequestBody ProcInvalidDTO invalidDTO);

    /**
     * 中断流程
     * <p>
     * 删除流程实例
     *
     * @param interceptDTO
     * @return
     */
    @PostMapping(value = "/interruptProcInst")
    ApiResult<String> interruptProcInst(@RequestBody ProcInterruptDTO interceptDTO);
}
