package com.elitesland.workflow;

import com.elitesland.workflow.enums.ProcInstStatus;

import java.util.ArrayList;
import java.util.List;

/**
 * @author yangzhibin
 * @date 2021/8/4
 */
public class WorkflowConstant {
    /**
     * 可以起流程的审批状态
     */
    public static final List<ProcInstStatus> CAN_START_PROC_STATUSES = new ArrayList<ProcInstStatus>() {{
        add(ProcInstStatus.APPROVED);
        add(ProcInstStatus.INVALID);
        add(ProcInstStatus.INTERRUPT);
        add(ProcInstStatus.DELETE);
    }};

    /**
     * 可删除流程状态
     */
    public static final List<ProcInstStatus> CAN_DELETE_PROC = new ArrayList<ProcInstStatus>() {{
        add(ProcInstStatus.NOTSUBMIT);
        add(ProcInstStatus.REJECTED);
        add(ProcInstStatus.APPROVING);
    }};


//    /**
//     * HTTP请求头 租户的ID
//     */
//    public static String HEADER_TENANT_ID = "X-Tenant-Id";
//
//    /**
//     * HTTP请求头 用户的ID
//     */
//    public static String HEADER_USER_ID = "X-User-Id";


    /**
     * 请求路径
     */
    public static final String TASK_ASSIGNEE_PATH = "/taskAssignee";
    public static final String TASK_CREATED_PATH = "/taskCreated";
    public static final String TASK_COMPLETED_PATH = "/taskCompleted";
    public static final String PROCESS_STATUS_CHANGE_PATH = "/processStatusChange";

    public static final String WORKFLOW = "/rpc/workflow/";
    public static final String CALLBACK = "/callBack";

    /**
     * 设置的流程变量-回调地址
     */
    public static final String PROCESS_VARIABLE_CALLBACK = "_cloudt_callback";
    public static final String PROCESS_VARIABLE_CALLBACK_METHOD = "_cloudt_callback_method";
}
