package com.elitesland.workflow.payload;

import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Data;

/**
 * @author yangzhibin
 * @date 2022/11/27
 */
@Data
public class ProcessStatusChangePayload {
    /**
     * 租户ID
     */
    private String tenantId;
    /**
     * 流程实例ID
     */
    private String procInstId;
    /**
     * 流程定义KEY
     */
    private String procDefKey;
    /**
     * 流程实例的状态
     */
    private ProcInstStatus procInstStatus;
    /**
     * 业务主键
     */
    private String businessKey;
    /**
     * 评论信息
     */
    private CommentInfo commentInfo;

    public static ProcessStatusChangePayload of(String tenantId, String procInstId, String procDefKey, ProcInstStatus procInstStatus, String businessKey, CommentInfo commentInfo) {
        ProcessStatusChangePayload payload = new ProcessStatusChangePayload();
        payload.setTenantId(tenantId);
        payload.setProcInstId(procInstId);
        payload.setProcDefKey(procDefKey);
        payload.setProcInstStatus(procInstStatus);
        payload.setBusinessKey(businessKey);
        payload.setCommentInfo(commentInfo);
        return payload;
    }
}
