package com.elitesland.workflow.payload;

import lombok.Data;

/**
 * @author yangzhibin
 * @date 2022/11/27
 */
@Data
public class TaskCompletedPayload {
    /**
     * 租户ID
     */
    private String tenantId;
    /**
     * 流程实例ID
     */
    private String procInstId;
    /**
     * 流程定义KEY
     */
    private String procDefKey;
    /**
     * 任务定义KEY
     */
    private String taskKey;
    /**
     * 任务名称
     */
    private String taskName;
    /**
     * 业务主键
     */
    private String businessKey;
    /**
     * 任务处理人
     */
    private String taskHandler;
    private String customParams;
    private String customParams2;

    public static TaskCompletedPayload of(String tenantId, String procInstId, String procDefKey, String taskKey, String taskName, String businessKey, String taskHandler, String customParams, String customParams2) {
        TaskCompletedPayload payload = new TaskCompletedPayload();
        payload.setTenantId(tenantId);
        payload.setProcInstId(procInstId);
        payload.setProcDefKey(procDefKey);
        payload.setTaskKey(taskKey);
        payload.setTaskName(taskName);
        payload.setBusinessKey(businessKey);
        payload.setTaskHandler(taskHandler);
        payload.setCustomParams(customParams);
        payload.setCustomParams2(customParams2);
        return payload;
    }
}
