package com.elitescloud.cloudt.workflow.service.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.workflow.Application;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;

/**
 * 工作流服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/20
 */
@FeignClient(name = Application.NAME, path = WorkflowRpcService.URI)
public interface WorkflowRpcService {
    String URI = Application.URI_PREFIX + "/service";

    /**
     * 是否就绪
     *
     * @return 是否就绪
     */
    @GetMapping(value = "/ready")
    ApiResult<Boolean> ready();
}
