package com.elitesland.workflow;

import com.elitesland.workflow.enums.ActionType;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 任务审批信息
 *
 * @author yangzhibin
 * @date 2021/1/11
 */
@Data
public class CommentInfo implements Serializable {

    private static final long serialVersionUID = -5611586043356745738L;

    /**
     * 任务定义KEY
     */
    private String taskDefKey;

    /**
     * 任务名称
     */
    private String taskName;

    /**
     * 审批人
     */
    private String userName;

    /**
     * 审批人userId
     */
    private String userId;

    /**
     * 类型
     */
    private ActionType type;

    /**
     * 时间
     */
    private LocalDateTime time;

    /**
     * 审批意见
     */
    private String comment;

}
