package com.elitesland.workflow;

import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author yangzhibin
 * @date 2023/5/9
 */
@Data
public class NodeInfo {

    /**
     * 当前审批节点
     */
    private Integer currentNodeIndex;

    /**
     * 节点信息
     */
    private List<Node> nodes;


    @Data
    public static class Node {
        /**
         * 节点Key
         */
        private String nodeKey;

        /**
         * 节点名称
         */
        private String nodeName;

        /**
         * 最后一次操作人用户姓名
         */
        private String lastOptUserName;

        /**
         * 最后一次操作时间
         */
        private LocalDateTime lastOptTime;
    }
}
