package com.elitesland.workflow.payload;

import com.elitesland.workflow.CommentInfo;
import lombok.Data;

import java.util.Set;

/**
 * @author yangzhibin
 * @date 2022/11/27
 */
@Data
public class TaskCreatedPayload {
    /**
     * 租户ID
     */
    private String tenantId;
    /**
     * 流程实例ID
     */
    private String procInstId;
    /**
     * 流程定义KEY
     */
    private String procDefKey;
    /**
     * 任务定义KEY
     */
    private String taskKey;
    /**
     * 任务名称
     */
    private String taskName;
    /**
     * 业务主键
     */
    private String businessKey;
    /**
     * 任务执行人
     */
    private Set<String> taskAssignees;
    /**
     * 评论信息
     */
    private CommentInfo commentInfo;
    private String customParams;
    private String customParams2;

    public static TaskCreatedPayload of(String tenantId, String procInstId, String procDefKey, String taskKey, String taskName, String businessKey, Set<String> taskAssignees, CommentInfo commentInfo, String customParams, String customParams2) {
        TaskCreatedPayload payload = new TaskCreatedPayload();
        payload.setTenantId(tenantId);
        payload.setProcInstId(procInstId);
        payload.setProcDefKey(procDefKey);
        payload.setTaskKey(taskKey);
        payload.setTaskName(taskName);
        payload.setBusinessKey(businessKey);
        payload.setTaskAssignees(taskAssignees);
        payload.setCommentInfo(commentInfo);
        payload.setCustomParams(customParams);
        payload.setCustomParams2(customParams2);
        return payload;
    }
}
