package com.elitesland.workflow.enums;

import lombok.Getter;

/**
 * 动作类型
 *
 * @author yangzhibin
 * @date 2020/8/11
 */
public enum ActionType {
    /**
     * 流程动作类型
     */
    SUBMIT("提交"),
    BATCH_SUBMIT("批量提交"),
    AGREE("通过"),
    DISAGREE("不通过"),
    BATCH_AGREE("批量通过"),
    AUTO_AGREE("连续审批"),
    REJECTED("驳回"),
    REVOKE("撤回"),
    ADD_SIGN_BEFORE("前加签"),
    ADD_SIGN_AFTER("后加签"),
    DELEGATION("委派"),
    TRANSFER("转办"),
    INVALID("作废"),
    /**
     * 管理员动作类型
     */
    CHANGE_TASK_ASSIGNESS("修改任务负责人"),
    ADMIN_AGREE("往后推一个节点"),
    INTERRUPT("中断执行"),
    DELETE("删除"),
    ;

    @Getter
    private String desc;

    ActionType(String desc) {
        this.desc = desc;
    }

}
