package com.elitesland.workflow.enums;

import lombok.Getter;

/**
 *
 * 流程实例状态
 * @author yangzhibin
 * @date 2020/8/7
 */
public enum ProcInstStatus {
    NOTSUBMIT("未提交"),
    APPROVING("审批中"),
    APPROVED("审批通过"),
    REJECTED("审批拒绝"),
    DISAGREE("不同意"),
    INVALID("作废"),
    INTERRUPT("中断执行"),
    DELETE("删除"),
    ;

    /**
     * 描述
     */
    @Getter
    private String desc;

    ProcInstStatus(String desc) {
        this.desc = desc;
    }

}
