package com.elitesland.workflow.exception;

import lombok.Getter;

/**
 * 业务异常
 * @author yangzhibin
 * @date 2020/8/7
 */
public class WorkflowException extends RuntimeException {
    private static final long serialVersionUID = -6954465231080544680L;

    /**
     * 错误码
     */
    @Getter
    private int code = 500;

    public WorkflowException(String message) {
        super(message);
    }

    public WorkflowException(int code, String message) {
        super(message);
        this.code = code;
    }

}
