package com.elitesland.workflow.payload;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.HashMap;

/**
 * @author yangzhibin
 * @date 2022/11/27
 */
@Data
public class StartProcessPayload {
    /**
     * 流程定义Key
     */
    @NotBlank(message = "流程定义Key不能为空")
    private String processDefinitionKey;
    /**
     * 流程实例名称
     */
    private String procInstName;
    /**
     * 业务主键
     */
    @NotBlank(message = "业务主键不能为空")
    private String businessKey;
    /**
     * 启动参数
     */
    private HashMap<String, Object> variables;
    /**
     * 启动意见
     */
    private String comment;

    /**
     * 启动人ID
     * <p>
     * 为空则依据token解析
     */
    private String starterId;

    /**
     * 租户ID
     */
    private String tenantId;

    public static StartProcessPayload of(String processDefinitionKey, String procInstName, String businessKey, HashMap<String, Object> variables) {
        StartProcessPayload payload = new StartProcessPayload();
        payload.setProcessDefinitionKey(processDefinitionKey);
        payload.setProcInstName(procInstName);
        payload.setBusinessKey(businessKey);
        payload.setVariables(variables);
        return payload;
    }
}
