/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.workflow.config;

import cn.hutool.core.collection.ListUtil;
import com.elitescloud.cloudt.workflow.config.common.FeignHeaderCustomizer;
import io.seata.core.context.RootContext;
import io.seata.spring.boot.autoconfigure.SeataAutoConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;

@ConditionalOnClass(value={SeataAutoConfiguration.class, FeignAutoConfiguration.class})
public class FeignSeataConfig {
    private static final Logger log = LoggerFactory.getLogger(FeignSeataConfig.class);
    private static final Logger logger = LoggerFactory.getLogger(FeignSeataConfig.class);

    @Bean
    public FeignHeaderCustomizer feignHeaderCustomizerSeata() {
        log.info("Feign\u81ea\u5b9a\u4e49\u8bf7\u6c42\u5934\uff1aSeata");
        return requestTemplate -> {
            String xid = RootContext.getXID();
            if (StringUtils.hasText((String)xid)) {
                requestTemplate.header("TX_XID", (Iterable)ListUtil.toList((Object[])new String[]{xid}));
            }
            logger.info("seata xid:{}", (Object)xid);
        };
    }
}

