package com.elitescloud.cloudt.workflow.config;

import cn.hutool.core.collection.ListUtil;
import com.elitescloud.cloudt.workflow.config.common.FeignHeaderCustomizer;
import io.seata.core.context.RootContext;
import io.seata.spring.boot.autoconfigure.SeataAutoConfiguration;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;

/**
 * Feign与Seata的集成配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/7/25
 */
@ConditionalOnClass({SeataAutoConfiguration.class, FeignAutoConfiguration.class})
@Slf4j
public class FeignSeataConfig {
    private static final Logger logger = LoggerFactory.getLogger(FeignSeataConfig.class);

    @Bean
    public FeignHeaderCustomizer feignHeaderCustomizerSeata() {
        log.info("Feign自定义请求头：Seata");
        return requestTemplate -> {
            String xid = RootContext.getXID();
            if (StringUtils.hasText(xid)) {
                requestTemplate.header(RootContext.KEY_XID, ListUtil.toList(xid));
            }
            logger.info("seata xid:{}", xid);
        };
    }
}
