package com.elitescloud.cloudt.workflow.params;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/7/10 周四
 */
@Getter
@Setter
public class FileInfoDTO implements Serializable {
    private static final long serialVersionUID = -3702067711364057718L;

    @NotBlank(message = "文件编码不能为空")
    @ApiModelProperty(value = "文件编码，文件的唯一标识", required = true)
    private String fileCode;

    @NotBlank(message = "文件名称不能为空")
    @ApiModelProperty(value = "文件原名称", required = true)
    private String originalName;

    @ApiModelProperty(value = "文件大小，字节B")
    private Long fileSize;

    @ApiModelProperty(value = "文件内容类型，mime-type")
    private String mimeType;

}
