package com.elitescloud.cloudt.workflow.params;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 任务节点配置.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/8
 */
@Getter
@Setter
public class TaskNodeConfigDTO implements Serializable {
    private static final long serialVersionUID = 2784386766292646295L;

    /**
     * ID
     */
    private Long id;

    /**
     * 流程定义key
     */
    private String procDefKey;

    /**
     * 任务节点ID
     */
    private String taskDefId;

    /**
     * 处理人类型
     */
    private String assigneeType;
    /**
     * 节点自定义配置
     */
    private String customParams;
    /**
     * 节点自定义配置2
     */
    private String customParams2;
    /**
     * 处理人ID
     */
    private List<String> assigneeUserIds;

    /**
     * 是否支持撤回
     */
    private boolean supportWithdraw ;
    /**
     * 是否支持从该节点驳回
     */
    private boolean supportRejectedFrom ;
    /**
     * 是否支持驳回到该节点
     */
    private boolean supportRejectedTo ;
    /**
     * 是否支持前加签
     */
    private boolean supportAddSignBefore ;
    /**
     * 是否支持后加签
     */
    private boolean supportAddSignAfter ;
    /**
     * 是否支持委派
     */
    private boolean supportDelegation ;
    /**
     * 是否支持转办
     */
    private boolean supportTransfer ;
    /**
     * 支持连续审批
     */
    private Integer supportContinuousComplete;
    /**
     * 流程变量
     */
    private List<TaskNodeConfigVariableConditionDTO> variableConditionList;

    /**
     * 扩展参数
     */
    private String es1;
    private String es2;
    private String es3;
    private String es4;
    private String es5;
}
