package com.elitescloud.cloudt.workflow.service.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.workflow.Application;
import com.elitescloud.cloudt.workflow.params.ProcDefDTO;
import com.elitescloud.cloudt.workflow.params.TaskNodeConfigDTO;
import com.elitescloud.cloudt.workflow.params.save.ProcDefSaveDTO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 流程定义服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/19
 */
@FeignClient(name = Application.NAME, path = ProcDefRpcService.URI)
public interface ProcDefRpcService {
    String URI = Application.URI_PREFIX + "/procDef";

    /**
     * 保存流程定义
     *
     * @param saveDTD 参数信息
     * @return 流程定义ID
     */
    @PostMapping(value = "/save")
    ApiResult<Long> save(@RequestBody ProcDefSaveDTO saveDTD);

    /**
     * 根据流程定义key删除
     *
     * @param procDefKey 流程定义Key
     * @return 删除结果
     */
    @DeleteMapping(value = "/delete")
    ApiResult<String> deleteByKey(@RequestParam(name = "procDefKey") @NotBlank(message = "流程定义Key为空") String procDefKey);

    /**
     * 获取流程定义信息
     *
     * @param procDefKey 流程定义Key
     * @return 流程定义信息
     */
    @GetMapping(value = "/procDef")
    ApiResult<ProcDefDTO> getProcDef(@RequestParam(name = "procDefKey") @NotBlank(message = "流程定义Key为空") String procDefKey);

    /**
     * 获取节点配置
     *
     * @param procDefKey 流程定义key
     * @param taskDefId  任务节点id，为空则是流程的所有配置节点
     * @return 节点配置列表
     */
    @GetMapping(value = "/taskNodeConfig")
    ApiResult<List<TaskNodeConfigDTO>> getNodeConfig(@RequestParam(name = "procDefKey") @NotBlank(message = "流程定义Key为空") String procDefKey,
                                                     @RequestParam(name = "taskDefId", required = false) String taskDefId);

    /**
     * 部署流程
     *
     * @param procDefKey 流程定义Key
     * @return 部署结果
     */
    @GetMapping(value = "/deploy")
    ApiResult<Boolean> deploy(@RequestParam(name = "procDefKey") @NotBlank(message = "流程定义Key为空") String procDefKey);
}
