package com.elitesland.workflow.payload;

import lombok.Data;

/**
 * @author yangzhibin
 * @date 2022/11/27
 */
@Data
public class TaskAssigneePayload {
    /**
     * 租户ID
     */
    private String tenantId;
    /**
     * 流程实例ID
     */
    private String procInstId;
    /**
     * 流程定义KEY
     */
    private String procDefKey;
    /**
     * 任务定义KEY
     */
    private String taskKey;
    /**
     * 业务主键
     */
    private String businessKey;
    private String customParams;
    private String customParams2;

    public static TaskAssigneePayload of(String tenantId, String procInstId, String procDefKey, String taskKey, String businessKey,
                                         String customParams, String customParams2) {
        TaskAssigneePayload payload = new TaskAssigneePayload();
        payload.setTenantId(tenantId);
        payload.setProcInstId(procInstId);
        payload.setProcDefKey(procDefKey);
        payload.setTaskKey(taskKey);
        payload.setBusinessKey(businessKey);
        payload.setCustomParams(customParams);
        payload.setCustomParams2(customParams2);
        return payload;
    }
}
