/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.workflow;

import com.elitescloud.cloudt.workflow.params.ProcDefDTO;
import com.elitescloud.cloudt.workflow.params.TaskNodeConfigDTO;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.TaskInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.payload.ApprovePayload;
import com.elitesland.workflow.payload.CurrentTaskInfosPayload;
import com.elitesland.workflow.payload.DeleteProcessPayload;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="cloudt-workflow", path="/rpc/cloudt/workflow/wf")
public interface WorkflowService {
    public static final String URI = "/rpc/cloudt/workflow/wf";

    @GetMapping(value={"/hello"})
    public WorkflowResult<String> hello(@RequestParam(name="username", required=false) String var1);

    @PostMapping(value={"/workflow/api/startProcess"})
    public WorkflowResult<ProcessInfo> startProcess(@RequestBody StartProcessPayload var1);

    @PostMapping(value={"/workflow/api/setVariables"})
    public WorkflowResult<Object> setVariables(@RequestBody SetVariablesPayload var1);

    @PostMapping(value={"/workflow/api/currentTaskInfos"})
    public WorkflowResult<HashMap<String, TaskInfo>> currentTaskInfos(@RequestBody CurrentTaskInfosPayload var1);

    @PostMapping(value={"/workflow/api/currentTaskInfo"})
    public WorkflowResult<TaskInfo> currentTaskInfo(@RequestParam(name="procInstId") String var1);

    @PostMapping(value={"/workflow/api/commentInfos"})
    public WorkflowResult<ArrayList<CommentInfo>> commentInfos(@RequestParam(name="procInstId") String var1);

    @PostMapping(value={"/workflow/api/deleteProcess"})
    public WorkflowResult<Object> deleteProcess(@RequestBody DeleteProcessPayload var1);

    @GetMapping(value={"/workflow/api/canBackNodes"})
    public WorkflowResult<Object> canBackNodes(@RequestParam(name="procInstId") String var1);

    @PostMapping(value={"/workflow/api/approve"})
    public WorkflowResult<Object> approve(@RequestBody @Validated ApprovePayload var1);

    @GetMapping(value={"/workflow/api/taskNodeConfig"})
    public WorkflowResult<List<TaskNodeConfigDTO>> getNodeConfig(@RequestParam(name="procDefKey") @NotBlank(message="\u6d41\u7a0b\u5b9a\u4e49Key\u4e3a\u7a7a") @NotBlank(message="\u6d41\u7a0b\u5b9a\u4e49Key\u4e3a\u7a7a") String var1, @RequestParam(name="taskDefId", required=false) String var2);

    @GetMapping(value={"/workflow/api/procDef"})
    public WorkflowResult<ProcDefDTO> getProcDef(@RequestParam(name="procDefKey") @NotBlank(message="\u6d41\u7a0b\u5b9a\u4e49Key\u4e3a\u7a7a") @NotBlank(message="\u6d41\u7a0b\u5b9a\u4e49Key\u4e3a\u7a7a") String var1);

    @GetMapping(value={"/workflow/api/userTaskNames"})
    public WorkflowResult<Map<String, String>> getUserTaskNames(@RequestParam(name="procDefKey") @NotBlank(message="\u6d41\u7a0b\u5b9a\u4e49Key\u4e3a\u7a7a") @NotBlank(message="\u6d41\u7a0b\u5b9a\u4e49Key\u4e3a\u7a7a") String var1);
}

