package com.elitesland.yst.common.base;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 数据库实体基础类VO
 *
 * @author Moz
 * @date 3/17/2020
 */
@Data
public class BaseViewModel implements Serializable {

    @Serial
    private static final long serialVersionUID = 8856368218499373995L;

    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 租户ID
     */
    @ApiModelProperty(value = "租户ID")
    Long tenantId;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;

    /**
     * 记录创建者
     */
    @ApiModelProperty("记录创建者")
    private String creator;

    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;

    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId = 0L;

    /**
     * 记录最后更新者
     */
    @ApiModelProperty("记录最后更新者")
    String updater;

    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;

    /**
     * 逻辑删除标识
     */
    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag = 0;

    /**
     * 锁版本
     */
    @ApiModelProperty(value = "锁版本")
    private Integer auditDataVersion;
}
