package com.elitesland.yst.common.base;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.util.CollectionUtils;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 分页信息
 *
 * @author Michael Li
 * @date 2018-11-08
 */
@ApiModel("分页")
@Data
@Accessors(chain = true)
@Builder
public class PagingVO<T extends Serializable> implements Serializable {

    private static final long serialVersionUID = -1683800405530086022L;

    /**
     * 总记录数
     */
    @ApiModelProperty("总行数")
    private Long total;

    /**
     * 数据列表
     */
    @ApiModelProperty("数据列表")
    private List<T> records;

    public PagingVO() {
        this(0L, Collections.emptyList());
    }

    public PagingVO(long total, List<T> records) {
        this.total = total;
        this.records = records;
    }

    /**
     * 空记录
     *
     * @return
     * @param <T>
     */
    public static <T extends Serializable> PagingVO<T> empty() {
        return new PagingVO<>();
    }

    public <R extends Serializable> PagingVO<R> map(@NotNull Function<T, R> mapper) {
        if (CollectionUtils.isEmpty(records)) {
            return new PagingVO<>();
        }

        List<R> result = records.stream().map(mapper).collect(Collectors.toList());
        return new PagingVO<>(total, result);
    }

    public boolean isEmpty() {
        return CollectionUtils.isEmpty(records);
    }

    @Override
    public String toString() {
        return "Paging{" +
                "total=" + total +
                ", records=" + records +
                '}';
    }
}
