package com.elitesland.yst.common.condition;

import com.elitesland.yst.common.condition.support.OnRpcCondition;
import org.springframework.context.annotation.Conditional;

import java.lang.annotation.*;

/**
 * 是否启用RPC.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/28
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD})
@Documented
@Conditional(OnRpcCondition.class)
public @interface ConditionalOnRpc {

    /**
     * 是否必须有OpenFeign
     *
     * @return
     */
    boolean requiredOpenFeign() default false;

    /**
     * 是否必须有dubbo
     *
     * @return
     */
    boolean requiredDubbo() default false;
}
