package com.elitesland.yst.common.config.cache;

import com.elitesland.yst.common.util.RedLockUtils;
import com.elitesland.yst.common.util.RedisUtils;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.RedisTemplate;

/**
 * redis相关配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/27
 */
@ConditionalOnClass(name = {"com.elitesland.cloudt.context.redis.CloudtRedisAutoConfiguration"})
@AutoConfigureAfter(name = {"com.elitesland.cloudt.context.redis.CloudtRedisAutoConfiguration", "com.elitesland.cloudt.context.redis.redisson.RedissonCustomAutoConfiguration"})
public class RedisCacheAutoConfiguration {

    @Bean
    @ConditionalOnBean({RedisTemplate.class, CacheKeyGenerator.class})
    public RedisUtils redisUtils(RedisTemplate<Object, Object> redisTemplate,
                                 CacheKeyGenerator keyGenerator) {
        return new RedisUtils(redisTemplate, keyGenerator);
    }

    @Bean
    @ConditionalOnBean({CacheKeyGenerator.class})
    public RedLockUtils redLockUtils(CacheKeyGenerator keyGenerator,
                                     ObjectProvider<RedissonClient> redissonClientObjectProvider) {
        return new RedLockUtils(keyGenerator, redissonClientObjectProvider);
    }
}
