package org.hibernate.annotations;

import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * <p>
 * 功能说明:覆盖源码 支持继承
 *  具体源码参见 org.hibernate.annotations#Filter
 * </p>
 *
 * @author roman
 * @since 2022/2/23 5:24 PM
 */
@Target({TYPE, METHOD, FIELD})
@Retention(RUNTIME)
@Repeatable(Filters.class)
public @interface Filter {
    /**
     * The filter name.
     */
    String name();

    /**
     * The filter condition.  If empty, the default condition from the correspondingly named {@link FilterDef} is used.
     */
    String condition() default "";

    /**
     * If true, automatically determine all points within the condition fragment that an alias should be injected.
     * Otherwise, injection will only replace instances of explicit "{alias}" instances or
     * {@link SqlFragmentAlias} descriptors.
     */
    boolean deduceAliasInjectionPoints() default true;

    /**
     * The alias descriptors for injection.
     */
    SqlFragmentAlias[] aliases() default {};
}
