package com.elitesland.yst.dms.osf.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.dms.osf.Application;
import com.elitesland.yst.dms.osf.rpc.param.CustRpcDTO;
import com.elitesland.yst.dms.osf.rpc.param.CustRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 客户rpc.
 */
@FeignClient(name = Application.NAME, path = CustRpcService.URI)
@Validated
public interface CustRpcService {
    String URI = Application.URI_PREFIX + "/cust";

    @PostMapping(value = "/query")
    ApiResult<List<CustRpcDTO>> query(@RequestBody CustRpcParam param);
}
