package com.elitesland.nc.service.impl;

import com.alibaba.fastjson.JSON;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.sys.outlog.param.PushRecordDTO;
import com.elitescloud.cloudt.sys.outlog.rpc.OutsidePushRecordRepository;
import com.elitesland.nc.client.NcForestClient;
import com.elitesland.nc.config.NcProperties;
import com.elitesland.nc.dto.NcRequestDTO;
import com.elitesland.nc.dto.NcResponseDTO;
import com.elitesland.nc.exception.NcApiException;
import com.elitesland.nc.service.NcService;
import com.elitesland.nc.util.NcResponseUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.security.MessageDigest;

@Slf4j
@Service
@RequiredArgsConstructor
// 配置文件动态刷新
@RefreshScope
public class NcServiceImpl implements NcService {

    private final NcProperties ncProperties;
    private final NcForestClient ncForestClient;
    private final OutsidePushRecordRepository outsidePushRecordRepository;


    @Override
    public String test() {
        log.info("ncProperties: {}", ncProperties);
        return "NC Hello, World!";
    }

    /**
     * 使用Forest框架调用NC接口 - 方式2：使用拦截器自动设置请求头
     */
    @Override
    public NcResponseDTO callNcApiWithForest(NcRequestDTO request) {
        if (!ncProperties.getEnabled()) {
            log.warn("NC接口未启用，跳过调用");
            NcResponseDTO response = new NcResponseDTO();
            response.setStatus("F");
            response.setMessage("NC接口未启用");
            return response;
        }

        try {
            log.info("Forest拦截器方式调用NC接口");
            log.info("请求参数: {}", JSON.toJSONString(request, true));

            // 调用Forest接口（使用拦截器自动设置请求头）
            String responseJson = ncForestClient.callNcApi(request);

            log.info("Forest接口原始响应: {}", responseJson);

            // 解析并检查响应
            NcResponseDTO response = NcResponseUtil.parseAndCheck(responseJson);

            log.info("Forest拦截器方式调用成功，状态: {}", response.getStatus());
            return response;

        } catch (NcApiException e) {
            log.error("NC接口业务异常: {}", e.getMessage());
            throw e; // 重新抛出NC业务异常
        } catch (Exception e) {
            log.error("Forest拦截器方式调用NC接口异常", e);
            throw new BusinessException("Forest调用NC接口失败: " + e.getMessage(), e);
        }
    }

    @Override
    public NcResponseDTO callNcApiWithForest(NcRequestDTO request, String pushRecordInterType, Long docId, String docNo) {
        Assert.notNull(request, "请求体不能为空");
        Assert.notNull(pushRecordInterType, "推送记录类型不能为空");
        Assert.notNull(docId, "推送单据ID不能为空");
        Assert.notNull(docNo, "推送单据编号不能为空");
        // Assert.isTrue(docId != null || CharSequenceUtil.isNotBlank(docNo), "推送单据ID和单据编号不能同时为空");
        if (!ncProperties.getEnabled()) {
            log.warn("NC接口未启用，跳过调用");
            NcResponseDTO response = new NcResponseDTO();
            response.setStatus("S");
            response.setMessage("NC接口未启用");
            return response;
        }
        PushRecordDTO pushRecordDTO = new PushRecordDTO();
        pushRecordDTO.setInterType(pushRecordInterType);
        pushRecordDTO.setDocNo(docNo);
        pushRecordDTO.setDocId(docId);
        pushRecordDTO.setReqSuccess(false);
        pushRecordDTO.setReqBody(request);
        try {
            log.info("Forest拦截器方式调用NC接口");
            log.info("请求参数: {}", JSON.toJSONString(request, true));

            // 调用Forest接口（使用拦截器自动设置请求头）
            String responseJson = ncForestClient.callNcApi(request);

            log.info("Forest接口原始响应: {}", responseJson);

            // 解析并检查响应
            NcResponseDTO response = NcResponseUtil.parseAndCheck(responseJson);
            pushRecordDTO.setRespBody(response);
            if (!response.isSuccess()) {
                pushRecordDTO.setErrorMsg(response.getErrorMessage());
            } else {
                pushRecordDTO.setReqSuccess(true);
            }
            outsidePushRecordRepository.savePushRecord(pushRecordDTO);
            log.info("Forest拦截器方式调用成功，状态: {}", response.getStatus());
            return response;

        } catch (NcApiException e) {
            log.error("NC接口业务异常: {}", e.getMessage(), e);
            pushRecordDTO.setErrorMsg(e.getMessage());
            pushRecordDTO.setReqSuccess(false);
            outsidePushRecordRepository.savePushRecord(pushRecordDTO);
            throw e; // 重新抛出NC业务异常
        } catch (Exception e) {
            log.error("Forest拦截器方式调用NC接口异常", e);
            pushRecordDTO.setErrorMsg(e.getMessage());
            pushRecordDTO.setReqSuccess(false);
            outsidePushRecordRepository.savePushRecord(pushRecordDTO);
            throw new BusinessException("Forest调用NC接口失败: " + e.getMessage(), e);
        }
    }


    /**
     * 使用Forest框架调用NC接口 - 方式1：手动设置URL参数
     */
    // public String callNcApiWithForestManual(NcRequestDTO request) {
    //     if (!ncProperties.getEnabled()) {
    //         log.warn("NC接口未启用，跳过调用");
    //         return "NC接口未启用";
    //     }
    //
    //     try {
    //         // 生成时间戳和token
    //         String timestamp = String.valueOf(System.currentTimeMillis());
    //         String token = getToken(ncProperties.getSecrect(), ncProperties.getUserCode(), timestamp);
    //
    //         log.info("Forest手动方式调用NC接口");
    //         log.info("请求参数: {}", JSON.toJSONString(request, true));
    //
    //         // 调用Forest接口（手动设置URL参数）
    //         ForestResponse<String> response = ncForestClient.callNcDataApiWithParams(
    //                 ncProperties.getAppId(),
    //                 ncProperties.getFrom(),
    //                 ncProperties.getUserCode(),
    //                 timestamp,
    //                 token,
    //                 request
    //         );
    //
    //         log.info("Forest响应状态: {}", response.getStatusCode());
    //         log.info("Forest响应内容: {}", response.getContent());
    //
    //         return response.getContent();
    //
    //     } catch (Exception e) {
    //         log.error("Forest手动方式调用NC接口异常", e);
    //         throw new RuntimeException("Forest调用NC接口失败: " + e.getMessage(), e);
    //     }
    // }


    /**
     * 调用NC接口
     */
    // public String callNcApi(NcRequestDTO request) {
    //     if (!ncProperties.getEnabled()) {
    //         log.warn("NC接口未启用，跳过调用");
    //         return "NC接口未启用";
    //     }
    //
    //     try {
    //         // 生成时间戳和token
    //         String timestamp = String.valueOf(System.currentTimeMillis());
    //         String token = getToken(ncProperties.getSecrect(), ncProperties.getUserCode(), timestamp);
    //
    //         // 构建请求头
    //         HttpHeaders headers = new HttpHeaders();
    //         headers.setContentType(MediaType.APPLICATION_JSON);
    //         // headers.set("appid", ncProperties.getAppId());
    //         // headers.set("timestamp", timestamp);
    //         // headers.set("token", token);
    //         // headers.set("from", ncProperties.getFrom());
    //
    //         // 构建请求体
    //         HttpEntity<NcRequestDTO> entity = new HttpEntity<>(request, headers);
    //
    //         // 调用接口
    //         String url = ncProperties.getUri() + "/service/muap/api?appid="
    //                 + ncProperties.getAppId() +
    //                 "&from=" + ncProperties.getFrom() +
    //                 "&usercode=" + ncProperties.getUserCode() +
    //                 "&timestamp=" + timestamp +
    //                 "&token=" + token;
    //         log.info("调用NC接口: {}", url);
    //         log.info("URL参数: appid={}, from={}, usercode={}, timestamp={}, token={}",
    //                 ncProperties.getAppId(), ncProperties.getFrom(), ncProperties.getUserCode(), timestamp, token);
    //
    //         ResponseEntity<String> response = restTemplate.exchange(
    //                 url, HttpMethod.POST, entity, String.class);
    //
    //         log.info("NC接口响应状态: {}", response.getStatusCode());
    //         log.info("NC接口原始响应: {}", response.getBody());
    //
    //         // 解析并检查响应
    //         String responseJson = response.getBody();
    //         NcResponseDTO ncResponse = NcResponseUtil.parseAndCheck(responseJson);
    //
    //         log.info("RestTemplate调用成功，状态: {}", ncResponse.getStatus());
    //         return responseJson;
    //
    //     } catch (Exception e) {
    //         log.error("调用NC接口异常", e);
    //         throw new RuntimeException("调用NC接口失败: " + e.getMessage(), e);
    //     }
    // }
    @Override
    public String getToken(String secret, String userCode, String timestamp) {
        Assert.hasText(secret, "secrect can not be null");
        Assert.hasText(userCode, "userCode can not be null");
        Assert.hasText(timestamp, "timestamp can not be null");
        String[] sign = new String[]{
                secret,
                userCode,
                timestamp
        };
        // String timestamp = System.currentTimeMillis() + "";
        // String[] sign = new String[]{
        //         ncProperties.getSecrect(),
        //         ncProperties.getUserCode(),
        //         timestamp
        // };
        try {
            return signature(sign);
        } catch (Exception e) {
            log.error("nc token error", e);
        }
        return "";
    }


    /**
     * SHA-1签名
     *
     * @param arr
     * @return
     * @throws Exception
     */
    public static String signature(String[] arr) throws Exception {

        StringBuilder content = new StringBuilder();
        for (int i = 0; i < arr.length; i++) {
            content.append(arr[i]);
        }
		/*
		MessageDigest md = null;
		String tmpStr = null;
		// SHA-1加密
		md = MessageDigest.getInstance("SHA-1");
		// 将四个参数拼成一个字符串进行SHA-1加密
		byte[] diagest = md.digest(content.toString().getBytes());
		tmpStr = byteToStr(diagest);
		*/

        return signature(content.toString(), "SHA-1");
    }

    public static String signature(String content, String algorithm) throws Exception {
        if (algorithm != null && (algorithm.equalsIgnoreCase("MD5") || algorithm.equalsIgnoreCase("SHA-1"))) {

        } else {
            //不支持的算法
            throw new Exception("不支持加密算法：" + algorithm);
        }
        MessageDigest md = null;
        String tmpStr = null;
        // SHA-1加密
        md = MessageDigest.getInstance(algorithm);
        // 将四个参数拼成一个字符串进行SHA-1加密
        byte[] diagest = md.digest(content.getBytes());
        tmpStr = byteToStr(diagest);

        return tmpStr;
    }

    /**
     *
     * 将字节数组转换为十六进制字符串
     *
     * @param byteArray
     * @return
     */

    private static String byteToStr(byte[] byteArray) {
        String strDigest = "";
        for (int i = 0; i < byteArray.length; i++) {
            strDigest += byteToHexStr(byteArray[i]);
        }
        return strDigest;

    }

    /**
     *
     * 将字节转换为十六进制字符串
     *
     * @param mByte
     * @return
     */

    private static String byteToHexStr(byte mByte) {

        char[] Digit = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A',
                'B', 'C', 'D', 'E', 'F'};

        char[] tempArr = new char[2];

        tempArr[0] = Digit[(mByte >>> 4) & 0X0F];

        tempArr[1] = Digit[mByte & 0X0F];

        String s = new String(tempArr);

        return s;

    }


}
