package com.elitesland.nc.exception;

/**
 * NC接口异常
 *
 * @author generated
 */
public class NcApiException extends RuntimeException {

    private static final long serialVersionUID = 1L;

    private final String status;
    private final String action;
    private final String billtype;

    public NcApiException(String message) {
        super(message);
        this.status = null;
        this.action = null;
        this.billtype = null;
    }

    public NcApiException(String message, Throwable cause) {
        super(message, cause);
        this.status = null;
        this.action = null;
        this.billtype = null;
    }

    public NcApiException(String status, String action, String billtype, String message) {
        super(String.format("NC接口调用失败 - 状态:%s, 动作:%s, 单据类型:%s, 错误信息:%s", 
                           status, action, billtype, message));
        this.status = status;
        this.action = action;
        this.billtype = billtype;
    }

    public String getStatus() {
        return status;
    }

    public String getAction() {
        return action;
    }

    public String getBilltype() {
        return billtype;
    }
}