/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.nc.interceptor;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestResponse;
import com.dtflys.forest.interceptor.Interceptor;
import com.elitesland.nc.config.NcProperties;
import com.elitesland.nc.service.NcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NcForestInterceptor
implements Interceptor<Object> {
    private static final Logger log = LoggerFactory.getLogger(NcForestInterceptor.class);
    private final NcProperties ncProperties;
    private final NcService ncService;

    public boolean beforeExecute(ForestRequest request) {
        try {
            if (!this.ncProperties.getEnabled().booleanValue()) {
                log.warn("NC\u63a5\u53e3\u672a\u542f\u7528\uff0c\u8df3\u8fc7\u8bf7\u6c42");
                return false;
            }
            String timestamp = String.valueOf(System.currentTimeMillis());
            String token = this.ncService.getToken(this.ncProperties.getSecrect(), this.ncProperties.getUserCode(), timestamp);
            request.addQuery("appid", (Object)this.ncProperties.getAppId());
            request.addQuery("from", (Object)this.ncProperties.getFrom());
            request.addQuery("usercode", (Object)this.ncProperties.getUserCode());
            request.addQuery("timestamp", (Object)timestamp);
            request.addQuery("token", (Object)token);
            request.addHeader("Content-Type", (Object)"application/json");
            log.info("Forest\u8bf7\u6c42NC\u63a5\u53e3: {}", (Object)request.getUrl());
            log.info("Forest URL\u53c2\u6570: appid={}, from={}, usercode={}, timestamp={}, token={}", new Object[]{this.ncProperties.getAppId(), this.ncProperties.getFrom(), this.ncProperties.getUserCode(), timestamp, token});
            return true;
        }
        catch (Exception e) {
            log.error("Forest\u62e6\u622a\u5668\u5904\u7406URL\u53c2\u6570\u5931\u8d25", (Throwable)e);
            throw new ForestRuntimeException("\u8bbe\u7f6eNC URL\u53c2\u6570\u5931\u8d25", (Throwable)e);
        }
    }

    public void onSuccess(Object data, ForestRequest request, ForestResponse response) {
        log.info("Forest\u8c03\u7528NC\u63a5\u53e3\u6210\u529f\uff0c\u54cd\u5e94\u72b6\u6001: {}", (Object)response.getStatusCode());
        log.info("Forest\u54cd\u5e94\u5185\u5bb9: {}", data);
    }

    public void onError(ForestRuntimeException ex, ForestRequest request, ForestResponse response) {
        log.error("Forest\u8c03\u7528NC\u63a5\u53e3\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u9519\u8bef: {}", response != null ? Integer.valueOf(response.getStatusCode()) : "unknown", (Object)ex.getMessage());
        log.error("Forest\u8bf7\u6c42\u8be6\u60c5: {}", (Object)request.toString());
    }

    public NcForestInterceptor(NcProperties ncProperties, NcService ncService) {
        this.ncProperties = ncProperties;
        this.ncService = ncService;
    }
}

