package com.elitescloud.cloudt.sys.merchant.query;

import com.elitescloud.boot.core.support.customfield.common.AbstractCustomFieldQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.util.List;

/**
 * 商户配置表
 *
 * @author duwh
 * @date 2025-11-11
 */
@Getter
@Setter
public class MerchantConfigQuery extends AbstractCustomFieldQueryParam implements Serializable{
    /** 主键ID 精确 */
    @ApiModelProperty("主键ID")
    private Long id;
    /** 类型 JST 聚水潭 精确 */
    @ApiModelProperty("类型 JST 聚水潭")
    private String type;
    /** 公司编码 精确 */
    @ApiModelProperty("公司编码")
    private String companyCode;
    /** 平台编码 精确 */
    @ApiModelProperty("平台编码")
    private String platformCode;
    /** 平台商户ID 精确 */
    @ApiModelProperty("平台商户ID")
    private String platformMerchantId;
    /** AppID 精确 */
    @ApiModelProperty("AppID")
    private String appid;
    /** AppKey 精确 */
    @ApiModelProperty("AppKey")
    private String appkey;
    /** accessToken 精确 */
    @ApiModelProperty("accessToken")
    private String accesstoken;
    /** 预留字段1 精确 */
    @ApiModelProperty("预留字段1")
    private String reserved1;
    /** 预留字段2 精确 */
    @ApiModelProperty("预留字段2")
    private String reserved2;
    /** 预留字段3 精确 */
    @ApiModelProperty("预留字段3")
    private String reserved3;
    /** 预留字段4 精确 */
    @ApiModelProperty("预留字段4")
    private String reserved4;
    /** 预留字段5 精确 */
    @ApiModelProperty("预留字段5")
    private String reserved5;
}
