package com.elitescloud.cloudt.sys.component.med;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import java.io.Serial;

/**
 * 医药基础实体类-单据主表.
 *
 * @author nc
 * @date 2025/9/15 周一
 */
@Getter
@Setter
@MappedSuperclass
public class BaseModelMedOrder extends CustomFieldBaseModel {
    @Serial
    private static final long serialVersionUID = 8543635117696143981L;

    @ApiModelProperty(value = "来源单据类别", notes = "[UDC]yst-supp:DOC_CLS")
    @Column(name = "root_doc_cls", length = 64)
    private String rootDocCls;
    @ApiModelProperty("来源单据类型")
    @Column(name = "root_doc_type", length = 64)
    private String rootDocType;
    @ApiModelProperty("来源单据Id")
    @Column(name = "root_doc_id")
    private Long rootDocId;
    @ApiModelProperty("来源单据编号")
    @Column(name = "root_doc_no", length = 64)
    private String rootDocNo;

    @ApiModelProperty("关联单据类型")
    @Column(name = "relate_doc_type", length = 64)
    private String relateDocType;
    @ApiModelProperty(value = "关联单据类别", notes = "[UDC]yst-supp:DOC_CLS")
    @Column(name = "relate_doc_cls", length = 256)
    private String relateDocCls;
    @ApiModelProperty("关联单据ID")
    @Column(name = "relate_doc_id")
    private Long relateDocId;
    @ApiModelProperty("关联单据编号")
    @Column(name = "relate_doc_no", length = 256)
    private String relateDocNo;

    @ApiModelProperty(value = "关联单据2类别", notes = "[UDC]yst-supp:DOC_CLS")
    @Column(name = "relate_doc2_cls", length = 64)
    private String relateDoc2Cls;
    @ApiModelProperty("关联单据2类型")
    @Column(name = "relate_doc2_type", length = 64)
    private String relateDoc2Type;
    @ApiModelProperty("关联单据2ID")
    @Column(name = "relate_doc2_id")
    private Long relateDoc2Id;
    @ApiModelProperty("关联单据2编号")
    @Column(name = "relate_doc2_no", length = 64)
    private String relateDoc2No;

    @ApiModelProperty("客商ID")
    @Column(name = "enterprise_id")
    private Long enterpriseId;
    @ApiModelProperty("客商编码")
    @Column(name = "enterprise_code")
    private String enterpriseCode;
    @ApiModelProperty("客商名称")
    @Column(name = "enterprise_name")
    private String enterpriseName;
    @ApiModelProperty(value = "客商客商类型", notes = "[UDC]yst-purc:ENTERPRISE_TYPE")
    @Column(name = "enterprise_type")
    private String enterpriseType;

    @ApiModelProperty(value = "是否免检")
    @Column(name = "qt")
    private Boolean qt;
}
