package com.elitescloud.cloudt.sys.component.med;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serial;

/**
 * 医药基础实体类-商品.
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/15 周一
 */
@Getter
@Setter
public class BaseModelVOMedItem extends CustomFieldBaseModelVo {
    @Serial
    private static final long serialVersionUID = 8543635117696143981L;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;
    @ApiModelProperty(value = "商品名称")
    private String itemName;
    @ApiModelProperty(value = "通用名称")
    private String generalName;
    @ApiModelProperty(value = "商品名")
    private String productName;
    @ApiModelProperty(value = "英文名称")
    private String englishName;
    @ApiModelProperty(value = "规格型号")
    private String spec;
    @ApiModelProperty(value = "浓度规格")
    private String concSpec;

    @ApiModelProperty(value = "生产厂家")
    private String manuFactory;
     @ApiModelProperty(value = "生产厂家名称")
    private String manuFactoryName;

    @ApiModelProperty(value = "批准文号")
    private String approvalNumber;

    @ApiModelProperty(value = "产地")
    private String origin;

    @SysCode(sys = "yst-supp", mod = "DOSAGE_FORM")
    @ApiModelProperty(value = "剂型, [UDC]yst-supp:DOSAGE_FORM")
    private String dosageForm;
    @ApiModelProperty(value = "剂型名称")
    private String dosageFormName;
}
