package com.elitesland.nc.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.nc.dto.NcRequestDTO;
import com.elitesland.nc.dto.NcResponseDTO;
import com.elitesland.nc.service.NcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * NC重试接口控制器
 *
 * @author duwh
 */
@RestController
@RequestMapping("/nc/retry")
@RequiredArgsConstructor
@Api(value = "NC重试接口", tags = {"NC重试接口"})
public class NcRetryController {

    private final NcService ncService;

    @PostMapping("/tryFun")
    @ApiOperation("NC重试接口")
    public ApiResult<NcResponseDTO> tryFun(@RequestBody NcRequestDTO request) {
        NcResponseDTO ncResponseDTO = ncService.callNcApiWithForest(request);
        if (!ncResponseDTO.isSuccess()) {
            return ApiResult.fail(ncResponseDTO.getErrorMessage());
        }
        return ApiResult.ok(ncResponseDTO);
    }

}
