/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.nc.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.elitesland.nc.dto.NcResponseDTO;
import com.elitesland.nc.exception.NcApiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class NcResponseUtil {
    private static final Logger log = LoggerFactory.getLogger(NcResponseUtil.class);

    public static NcResponseDTO parseAndCheck(String responseJson) throws NcApiException {
        if (!StringUtils.hasText((String)responseJson)) {
            throw new NcApiException("NC\u63a5\u53e3\u8fd4\u56de\u7a7a\u54cd\u5e94");
        }
        try {
            NcResponseDTO response = (NcResponseDTO)JSON.parseObject((String)responseJson, NcResponseDTO.class);
            if (response == null) {
                log.error("NC\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u5931\u8d25: {}", (Object)responseJson);
                throw new NcApiException("NC\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u5931\u8d25");
            }
            log.info("NC\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u7ed3\u679c: \u72b6\u6001={}, \u6d88\u606f={}, \u5355\u636e\u7c7b\u578b={}, \u52a8\u4f5c={}", new Object[]{response.getStatus(), response.getMessage(), response.getBilltype(), response.getAction()});
            if (response.isFailed()) {
                String errorMessage = response.getErrorMessage();
                log.error("NC\u63a5\u53e3\u8c03\u7528\u5931\u8d25: {}", (Object)errorMessage);
                throw new NcApiException(response.getStatus(), response.getAction(), response.getBilltype(), errorMessage);
            }
            if (!response.isSuccess()) {
                String errorMessage = String.format("NC\u63a5\u53e3\u8fd4\u56de\u672a\u77e5\u72b6\u6001: %s, \u6d88\u606f: %s", response.getStatus(), response.getMessage());
                log.error(errorMessage);
                throw new NcApiException(errorMessage);
            }
            log.info("NC\u63a5\u53e3\u8c03\u7528\u6210\u529f");
            return response;
        }
        catch (JSONException e) {
            log.error("NC\u63a5\u53e3\u54cd\u5e94JSON\u89e3\u6790\u5931\u8d25: {}", (Object)responseJson, (Object)e);
            throw new NcApiException("NC\u63a5\u53e3\u54cd\u5e94\u683c\u5f0f\u9519\u8bef: " + e.getMessage(), e);
        }
    }

    public static NcResponseDTO parseQuietly(String responseJson) {
        try {
            return NcResponseUtil.parseAndCheck(responseJson);
        }
        catch (Exception e) {
            log.warn("NC\u54cd\u5e94\u89e3\u6790\u5931\u8d25: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static boolean isSuccess(String responseJson) {
        NcResponseDTO response = NcResponseUtil.parseQuietly(responseJson);
        return response != null && response.isSuccess();
    }

    public static String getErrorMessage(String responseJson) {
        NcResponseDTO response = NcResponseUtil.parseQuietly(responseJson);
        return response != null ? response.getErrorMessage() : "\u54cd\u5e94\u89e3\u6790\u5931\u8d25";
    }
}

