package com.elitescloud.cloudt.sys.outlog;

import org.springframework.http.HttpMethod;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/6/24 周二
 */
public enum OutsidePushInter implements OutsideInter {

    SRM_PUR_PO_SAVE(OutsidePushTarget.SRM, OutsidePushDocType.PUR_PO, "向SRM推送[创建采购订单]", "/infinity/pur/purPo/save", HttpMethod.POST, false),
    SRM_PUR_PO_CLOSE(OutsidePushTarget.SRM, OutsidePushDocType.PUR_PO, "向SRM推送[关闭采购订单]", "/infinity/pur/purPo/close", HttpMethod.POST, false),
    SRM_PUR_PO_CANCEL(OutsidePushTarget.SRM, OutsidePushDocType.PUR_PO, "向SRM推送[取消采购订单]", "/infinity/pur/app/purPo/cancel", HttpMethod.POST, false),
    SRM_PUR_PO_UPDATE_PAYMENT(OutsidePushTarget.SRM, OutsidePushDocType.PUR_PO, "向SRM推送[更新采购订单的支付状态]", "/infinity/pur/purPo/update", HttpMethod.POST, false),
    SRM_PUR_PG_SAVE(OutsidePushTarget.SRM, OutsidePushDocType.PUR_PG, "向SRM推送[创建采购收货单]", "/infinity/std/gr/put/save", HttpMethod.POST, false),
    SRM_PUR_RNS_SAVE(OutsidePushTarget.SRM, OutsidePushDocType.PUR_RNS, "向SRM推送[创建采购退货申请单]", "/infinity/purRns/rnsSave", HttpMethod.POST, false),
    SRM_PUR_RNS_CANCEL(OutsidePushTarget.SRM, OutsidePushDocType.PUR_RNS, "向SRM推送[取消采购退货申请单]", "/infinity/purRns/rns/update", HttpMethod.POST, false),
    SRM_PUR_RNS_RECV_SAVE(OutsidePushTarget.SRM, OutsidePushDocType.PUR_RNS_REV, "向SRM推送[创建采购退货出库单]", "/infinity/std/gr/rns/save", HttpMethod.POST, false),

    BIP_PUR_GR_APPROVE(OutsidePushTarget.BIP, OutsidePushDocType.PUR_PG, "向BIP推送[采购订单审批]", "/nccloud/api/pu/order/operation/approve", HttpMethod.POST, false),
    BIP_PUR_GR_SAVE(OutsidePushTarget.BIP, OutsidePushDocType.PUR_PG, "向BIP推送[采购订单](采购收货单)", "/nccloud/api/pu/order/operation/save", HttpMethod.POST, false),
    BIP_PUR_RNS_RECV_SAVE(OutsidePushTarget.BIP, OutsidePushDocType.PUR_RNS_REV, "向BIP推送[采购订单](采购退货出库单)", "/nccloud/api/pu/order/operation/save", HttpMethod.POST, false),
    BIP_PUR_AP_SAVE(OutsidePushTarget.BIP, OutsidePushDocType.PUR_RNS_REV, "向BIP推送[应付单](采购收货单)", "/nccloud/api/arap/payablebill/insertandcommit", HttpMethod.POST, false),
    NC_SUPP_OU(OutsidePushTarget.NC, OutsidePushDocType.SUPP_OU, "nc向中台推送[公司](公司列表)", "/yst/support/openApi/orgOu/saveOrgOu", HttpMethod.POST, false),
    ITEM_SYNC_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.SUPPORT_ITEM, "中台推送[公司](商品主档)到NC", "/yst/support/nc/retry/tryFun", HttpMethod.POST, true),
    CUST_SYNC_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.PUR_CUST, "中台推送[公司](客户主档)到NC", "/yst/sale/nc/retry/tryFun", HttpMethod.POST, true),
    SUPPORT_SYNC_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.PUR_SUPP, "中台推送[公司](供应商主档)到NC", "/yst/pur/nc/retry/tryFun", HttpMethod.POST, true),
    ORDER_SAL_DO_SYNC_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.ORDER_SAL_DO, "中台推送[销售出库单]到NC", "/yst/pur/nc/retry/tryFun", HttpMethod.POST, true),
    ORDER_SAL_RSO_SYNC_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.ORDER_SAL_RSO, "中台推送[销售退货入库单]到NC", "/yst/pur/nc/retry/tryFun", HttpMethod.POST, true),


    INV_IDO_SYNC_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.INV_IDO, "中台推送[采购入库单]到NC", "/yst/pur/nc/retry/tryFun", HttpMethod.POST, true),
    INV_ODO_SYNC_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.INV_ODO, "中台推送[采购退货出库单]到NC", "/yst/pur/nc/retry/tryFun", HttpMethod.POST, true),
    INV_ADJUST_IDO_SYNC_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.INV_ADJUST_IDO, "中台推送[库存调整入库单]到NC", "/yst/pur/nc/retry/tryFun", HttpMethod.POST, true),
    INV_ADJUST_ODO_SYNC_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.INV_ADJUST_ODO, "中台推送[库存调整出库单]到NC", "/yst/pur/nc/retry/tryFun", HttpMethod.POST, true),
    ;

    private final OutsidePushTarget target;
    private final OutsidePushDocType docType;
    private final String description;
    private final String uri;
    private final HttpMethod uriMethod;
    /**
     * 是否需要自动重试
     */
    private final Boolean needRetry;

    OutsidePushInter(OutsidePushTarget target, OutsidePushDocType docType, String description, String uri, HttpMethod uriMethod, Boolean needRetry) {
        this.target = target;
        this.docType = docType;
        this.description = description;
        this.uri = uri;
        this.uriMethod = uriMethod;
        this.needRetry = needRetry;
    }

    public OutsidePushTarget getTarget() {
        return target;
    }

    public OutsidePushDocType getDocType() {
        return docType;
    }

    public Boolean getNeedRetry() {
        return needRetry;
    }

    @Override
    public String getTargetSystem() {
        return target.name();
    }

    @Override
    public String getDocTypeCode() {
        return docType.name();
    }

    @Override
    public String getInterCode() {
        return this.name();
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public String getUri() {
        return uri;
    }

    @Override
    public HttpMethod getUriMethod() {
        return uriMethod;
    }
}

    