package com.elitesland.nc.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * NC接口请求DTO
 *
 * @author duwh
 */
@Data
@ApiModel("NC接口请求DTO")
public class NcRequestDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 账套
     */
    @ApiModelProperty(value = "账套", required = true, example = "001")
    @NotBlank(message = "账套不能为空")
    private String account;

    /**
     * 单据类型
     */
    @ApiModelProperty(value = "单据类型", required = true, example = "MATERIAL")
    @NotBlank(message = "单据类型不能为空")
    private String billtype;

    /**
     * 数据内容（JSON字符串）
     */
    @ApiModelProperty(value = "数据内容", required = true)
    @NotBlank(message = "数据内容不能为空")
    private String data;

    /**
     * 数据类型
     */
    @ApiModelProperty(value = "数据类型", required = true, example = "hd.vo.muap.pub.BillVO")
    @NotBlank(message = "数据类型不能为空")
    private String datatype;

    /**
     * 动作
     */
    @ApiModelProperty(value = "动作", required = true, example = "WRITE")
    @NotBlank(message = "动作不能为空")
    private String action;

    /**
     * 用户ID
     */
    @ApiModelProperty(value = "用户ID", required = false)
    private String userid;

    /**
     * 密码
     */
    @ApiModelProperty(value = "密码", required = false)
    private String password;

    /**
     * 校验码
     */
    @ApiModelProperty(value = "校验码", required = false)
    private String checkcode;

    /**
     * 设备类型
     */
    @ApiModelProperty(value = "设备类型", required = false)
    private String devtype;

    /**
     * 设备ID
     */
    @ApiModelProperty(value = "设备ID", required = false)
    private String devid;
}